import React, { useState } from 'react'

const Intro2 = () => {
  const [expanded, setExpanded] = useState(false);

  const toggleExpand = () => {
    setExpanded(!expanded);
  };


const text = " The journey began over four and a half decades ago, in a five hundred square feet office space at Lahore’s historical WAPDA house. We had a vision to embark on a journey to create Pakistan’s leading engineering enterprise. Over the years, the spirit of our founders inspired our people to not just achieve the ordinary but the extraordinary. This belief became the foundation of Pakistan’s leading multinational conglomerate; Descon.<br/><br/> Today, Descon comprises Pakistan’s leading engineering enterprise, Descon Engineering, with a wealth of expertise in sectors such as Oil & Gas, Cement, Power, Hydro Power, Dams/Barrages/ Canals, Fertilizer, Renewable Energy, Sugar, Industrial, Chemical and Petrochemicals. We are renowned specialists in EPC, Construction, Maintenance/Industrial Services, Infrastructure, Manufacturing, and Automation & Control projects. Descon’s global presence spans the GCC, (including Kingdom of Saudi Arabia, UAE, Kuwait, Qatar, Oman), Iraq, Pakistan and South Africa.<br/><br/> Descon also owns and operates chemical and power plants, with allied interests in inspection and testing. Descon’s chemicals business comprises Descon Oxychem Limited. Our power business takes shape in the form of Descon Power Solutions (DPS), providing power plant operations and maintenance (O&M) services for thermal and renewable power plants in Pakistan. Descon also owns one independent Power Plant (IPP), Altern Energy Limited, 32 MW gas-based power plant.<br/><br/> In its continuing endeavor to spur economic growth in Pakistan, Descon’s recent foray into the agriculture sector seeks to innovate and improve upon the existing farm productivity and agriculture value-chain, help provide the nation with nutritious produces and sustained economic growth.<br/><br/> Driven by a clear vision and firm commitment, Descon strives to add value to our client’s business ventures by providing world-class services within the constraints of safety, quality, time and budget. Having forged an institution overcoming all challenges in the past, we now look forward to the future with renewed vigor and resolve to build an enduring legacy. <br/><br/>As part of our Corporate Social Responsibility, Descon takes immense pride in educating underprivileged youth keen to acquire technical skills and improve their livelihood through the Descon Technical Institute. DTI also provides vocational training to young aspiring students. <br/><br/>Our success derives from our core values and business philosophy which encourages a progressive and dynamic attitude. In terms of Quality and HSE, Descon is second to none.<br/><br/>"
  return (
    <div className='container spacer'>
    <div className='row'>
        <div className='col-lg-6 col-12'>
          <h1 className="title lh-5">Established in <span>1977,<br/> Descon comprises one <br/> of the largest </span>engineering<br/> firms in Pakistan, along<br/> with a diverse portfolio including power,<br/> chemicals and agriculture business lines</h1>
        </div>
        <div className='col-lg-6 col-12'>
        {expanded ? (
        <p dangerouslySetInnerHTML={{ __html: text }} />
      ) : (
        <p dangerouslySetInnerHTML={{ __html: text.slice(0, 1800) + '...' }} />
      )}
      <button className="button-more read" onClick={toggleExpand}>
        {expanded ? 'Read less' : 'Read more'}
      </button>
      </div>
    


    </div>
</div>
  )
}

export default Intro2